/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEASAD;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAAudioDataBlock
extends DataBlock {
    private ArrayList<CEASAD> aSADs = new ArrayList();
    private static final int maxNumDescriptors = 10;
    private static final int descriptorSize = 3;
    private static final int iAudioTagCode = 1;

    public CEAAudioDataBlock() {
        super(3);
        this.iDataBlockTagCode = 1;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aSADs.remove(n);
        this.adjustNumDescriptors(-1);
    }

    @Override
    public void removeAllDescriptors() {
        this.aSADs.clear();
        this.adjustNumDescriptors(0);
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        CEASAD cEASAD = (CEASAD)cEADescriptor;
        if (this.aSADs == null) {
            this.aSADs = new ArrayList(1);
        }
        if (this.aSADs.size() == 10) {
            bl = false;
        } else {
            this.aSADs.add(cEASAD);
            this.adjustNumDescriptors(1);
            bl = true;
        }
        return bl;
    }

    public ArrayList<CEASAD> getDescriptors() {
        return this.aSADs;
    }

    public void clearDescriptors() {
        this.aSADs.clear();
        this.aSADs = null;
        this.adjustNumDescriptors(0);
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.SHORT_AUDIO_DES.getBlockName();
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        super.setHeader(string.substring(0, 2));
        int n = 0;
        int n2 = 2;
        if (this.getCurrentNumDescriptors() != (string.length() - 2) / 6) {
            string2 = "ERROR: Descriptor length doesn't match length of descriptors";
            return string2;
        }
        while (n < this.getCurrentNumDescriptors()) {
            CEASAD cEASAD = new CEASAD();
            cEASAD.uploadDescriptorData(string.substring(n2, n2 + 6));
            this.aSADs.add(cEASAD);
            ++n;
            n2 += 6;
        }
        if (string.length() - n2 > 0) {
            string2 = "ERROR: Problem uploading Audio Data Block Data provided for data block exceeds capacity of data block";
            return string2;
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        String string = new String();
        string = string.concat(super.getHeader());
        for (int i = 0; i < this.getCurrentNumDescriptors(); ++i) {
            string = string.concat(this.aSADs.get(i).extractDescriptorData());
        }
        return string;
    }

    @Override
    public boolean isJustOneCopyAllowed() {
        return false;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }
}

